#ifndef ZMODELER_STRUCT_DEFS_INCLUDED
#define ZMODELER_STRUCT_DEFS_INCLUDED

/////////////////////////////////////////////////////////////////////
//          Constants definition
/////////////////////////////////////////////////////////////////////


#define  MAX_SPLINE_OPERANDS              4
#define  MAX_OBJ_OPERANDS                 6  // as a rule it is 0,1,2-vetices,
                                             //3-is an object index, 4 is an indicator
                                             //5 might be a pointer or like that
#define  MAX_OBJECT_NAMELENGTH            64

#define  Z3D_PROCTYPE_NORMALPROCESS       0x00000001L
#define  Z3D_PROCTYPE_PRESSABLE           Z3D_PROCTYPE_NORMALPROCESS
#define  Z3D_PROCTYPE_SINGLECALL          0x00000002L
#define  Z3D_PROCTYPE_ONOFFCALLS          0x00000004L
#define  Z3D_PROCTYPE_STAYINLIST          0x00000008L
#define  Z3D_PROCTYPE_ALTERNATIVE         0x00000080L //used in toolbars/menubars: ALT+


#define Z3D_PLUGSUPPORTS_IMPORT           0x00000001L
#define Z3D_PLUGSUPPORTS_EXPORT           0x00000002L
#define Z3D_PLUGSUPPORTS_TEXTURELOADING   0x00000004L
#define Z3D_PLUGSUPPORTS_PROCESSING       0x00000008L
#define Z3D_PLUGSUPPORTS_SCENEOPENSAVE    0x00000010L
#define Z3D_PLUGSUPPORTS_SYSREQUESTS      0x00000020L
#define Z3D_PLUGSUPPORTS_BLOCKSWORK       0x00000040L
#define Z3D_PLUGSUPPORTS_RENDERING        0x00000080L
#define Z3D_PLUGSUPPORTS_MISCFLAGS        0x00000100L
#define Z3D_PLUGSUPPORTS_MISCVALUES       0x00000200L
#define Z3D_PLUGSUPPORTS_SPECIALOBJECTS   0x00000400L


// draw results
#define Z3D_PLUGRESULT_REDRAWWIRE         0x00000001L
#define Z3D_PLUGRESULT_REDRAWBLOCKS       0x00000002L
#define Z3D_PLUGRESULT_UPDATEWIRE         0x00000004L
#define Z3D_PLUGRESULT_UPDATEBLOCKS       0x00000008L
#define Z3D_PLUGRESULT_REDRAW  (Z3D_PLUGRESULT_REDRAWWIRE | Z3D_PLUGRESULT_REDRAWBLOCKS)
#define Z3D_PLUGRESULT_UPDATE  (Z3D_PLUGRESULT_UPDATEWIRE | Z3D_PLUGRESULT_UPDATEBLOCKS)

#define Z3D_PLUGRESULT_MANUALDRAW         0x00000010L
#define Z3D_PLUGRESULT_NOCOVER            0x00000020L
#define Z3D_PLUGRESULT_LEVELCHANGED       0x00000040L
#define Z3D_PLUGRESULT_EDITMODECHANGED    0x00000080L //x,y,xy,z (request for buttons in fact)
#define Z3D_PLUGRESULT_SELECTIONCHANGED   0x00000100L
#define Z3D_PLUGRESULT_MARKAGECHANGED     0x00000200L
#define Z3D_PLUGRESULT_VISIBILITYCHANGED  0x00000400L
#define Z3D_PLUGRESULT_MISCCHANGED        0x00000800L
#define Z3D_PLUGRESULT_STOPPROCESS        0x00001000L //used in residents list
#define Z3D_PLUGRESULT_ENABLEPROC         0x00002000L
#define Z3D_PLUGRESULT_CHECKPROC          0x00004000L
#define Z3D_PLUGRESULT_ENDMODE            0x00008000L //if an error occured - switch this mode off

#define Z3D_PLUGRESULT_DEVICECHANGED      0x00010000L //horrible thing. avoid if possible.
#define Z3D_PLUGRESULT_3DDISABLE          0x00020000L //if error occured
#define Z3D_PLUGRESULT_3DREDRAW           0x00040000L //simply redraw it.
//forces to redraw views
#define Z3D_PLUGRESULT_VIEWSREDRAW        0x00080000L
#define Z3D_PLUGRESULT_VISUALCHANGES      (Z3D_PLUGRESULT_VIEWSREDRAW | Z3D_PLUGRESULT_REDRAW)
// custom results
#define Z3D_PLUGRESULT_UPDATEMESSAGE      0x80000000L //updates a message in Status bar;
#define  Z3D_PLUGRESULT_CURSORCHANGE      0x40000000L //update cursor.
#define Z3D_PLUGRESULT_THISVIEWONLY       0x20000000L

#define Z3D_PLUGRESULT_REDRAWTHIS      (Z3D_PLUGRESULT_THISVIEWONLY | Z3D_PLUGRESULT_VIEWSREDRAW)

#define SHOULD_REBUILD(a)      (0 != ((a) & (Z3D_PLUGRESULT_VISIBILITYCHANGED | Z3D_PLUGRESULT_LEVELCHANGED)))
#define SHOULD_REDRAW_VIEWS(a) (0 != ((a) & (Z3D_PLUGRESULT_VIEWSREDRAW | Z3D_PLUGRESULT_REDRAW | Z3D_PLUGRESULT_SELECTIONCHANGED | Z3D_PLUGRESULT_MARKAGECHANGED | Z3D_PLUGRESULT_VISIBILITYCHANGED | Z3D_PLUGRESULT_LEVELCHANGED)))

//////////////////////////////////////////////
//      Events to react to        //
//////////////////////////////////////////////
#define  Z3D_EVENT_LBD                    0x00000001L
#define  Z3D_EVENT_RBD                    0x00000002L
#define  Z3D_EVENT_MMLBD                  0x00000004L
#define  Z3D_EVENT_MMRBD                  0x00000008L
#define  Z3D_EVENT_MM                     0x00000010L
#define  Z3D_EVENT_KEY                    0x00000020L
#define  Z3D_EVENT_LBU                    0x00000040L
#define  Z3D_EVENT_RBU                    0x00000080L
#define  Z3D_EVENT_SCENECHANGED           0x00000100L
#define  Z3D_EVENT_SCENEREBUILD           0x00000200L
#define  Z3D_EVENT_PROGRAMLOADUNLOAD      0x00000400L
#define  Z3D_EVENT_PLUGINSLOADUNLOAD      0x00000800L
#define  Z3D_EVENT_RENDER                 0x00001000L
#define  Z3D_EVENT_RENDERED               0x00002000L
#define  Z3D_EVENT_VIEWREDRAW             0x00004000L
#define  Z3D_EVENT_SELECTIONCHANGED       0x00008000L
#define  Z3D_EVENT_MARKAGECHANGED         0x00010000L
#define  Z3D_EVENT_VISIBILITYCHANGED      0x00020000L
#define  Z3D_EVENT_MISCCHANGED            0x00040000L

#define  Z3D_EVENT_LEVELCHANGED           0x01000000L
#define  Z3D_EVENT_EDITMODECHANGED        0x02000000L
#define  Z3D_EVENT_MODECHANGED            0x04000000L
#define  Z3D_EVENT_DEVICECHANGED          0x08000000L

#define  Z3D_EVENT_SCENENEW               0x10000000L
#define  Z3D_EVENT_SCENEOPEN              0x20000000L//or merge.
#define  Z3D_EVENT_SCENESAVE              0x40000000L
#define  Z3D_EVENT_SCENEQUIT              0x80000000L
#define  Z3D_ALL_EVENTS                   0xFF0FFFFFL

#define Z3D_PROCPLACE_MENUBAR             0x00100000L
#define Z3D_PROCPLACE_MAINMENU            0x00200000L
#define Z3D_PROCPLACE_TOOLBAR             0x00300000L
#define Z3D_PROCPLACE_FLOATBAR            0x00400000L
#define Z3D_PROCPLACE_POPUPMENU           0x00500000L



//////////////////////////////////////////////
//      Currentstate modes                  //
//////////////////////////////////////////////
#define Z3D_MODE_SELECTED                 0x00000001L
#define Z3D_MODE_MULTY                    0x00000002L
#define Z3D_MODE_EXTENDED                 0x00000004L
#define Z3D_MODE_NORMALSAUTO              0x00000008L
#define Z3D_MODE_NORMALSEXTENDED          0x00000010L
#define Z3D_MODE_WHILEACTIONUPDATE        0x00000020L
#define Z3D_MODE_AXISVISIBLE              0x00000040L
#define Z3D_MODE_SIMPLE                    0x00000080L

/////// custom modes for programming:
#define Z3D_MODE_PROGRAMMING              0x00000100L
#define Z3D_MODE_DEBUGZMODELER            0x00001000L
#define Z3D_MODE_DEBUGPLUGS               0x00002000L
#define Z3D_MODE_DEBUGD3D                 0x00004000L
#define Z3D_MODE_DEBUGALL                 0x00008000L

/////// custom edit modes.
#define Z3D_MODE_FULLSCREENEDIT           0x00010000L

//////////////////////////////////////////////
//  Currentstate Drawing Modes modes    //
//////////////////////////////////////////////
#define Z3D_DRAWMODE_GDI                  0x00000001L
#define Z3D_DRAWMODE_GDI1                 0x00000002L//reserved
#define Z3D_DRAWMODE_GDI2                 0x00000004L//reserved
#define Z3D_DRAWMODE_GDI3                 0x00000008L//reserved
// D3D Drawing extentions:
#define Z3D_DRAWMODE_TEXTURED             0x00000100L
#define Z3D_DRAWMODE_BACKCULL             0x00000200L
#define Z3D_DRAWMODE_HIGHLIGHTSEL         0x00000400L
#define Z3D_DRAWMODE_HIGHLIGHTMARK        0x00000800L
#define Z3D_DRAWMODE_SHOWVERTS            0x00001000L
#define Z3D_DRAWMODE_SHOWFACEDOT          0x00002000L
// Editing Views extentions: (all unused)
#define Z3D_DRAWMODE_INACTIVEWIRE         0x00010000L
#define Z3D_DRAWMODE_INACTIVESOLID        0x00020000L
#define Z3D_DRAWMODE_INACTIVETEXTURED     0x00040000L
#define Z3D_DRAWMODE_INACTIVESEMITRANS    0x00080000L
#define Z3D_DRAWMODE_ACTIVEWIRE           0x00100000L
#define Z3D_DRAWMODE_ACTIVESOLID          0x00200000L
#define Z3D_DRAWMODE_ACTIVETEXTURED       0x00400000L
#define Z3D_DRAWMODE_ACTIVESEMITRANS      0x00800000L


//////////////////////////////
//  Custom tState definitions
//////////////////////////////
// Units
#define  Z3D_UNITFLAG_AUTORESCALE         0x0001L
#define  Z3D_UNITFLAG_2                   0x0002L
#define  Z3D_UNITFLAG_3                   0x0004L
#define  Z3D_UNITFLAG_4                   0x0008L

// Open/Save
#define  Z3D_OPENSAVE_AUTOSAVE            0x00000001L//&0xFF000000 to get minutes interval.
#define  Z3D_OPENSAVE_SPLINES             0x00000002L
#define  Z3D_OPENSAVE_CUSTOMSPLINES       0x00000004L
#define  Z3D_OPENSAVE_UNSUPPDATA          0x00000008L
#define  Z3D_OPENSAVE_VIEWS               0x00000100L
#define  Z3D_OPENSAVE_STOREIMAGES         0x00010000L
#define  Z3D_OPENSAVE_COMPRESSION         0x00080000L

///////////////////
// nViewFlags
// use 0xffffff to get custom background color.
#define  Z3D_VIEWFLAG_SEETHROUGH          0x01000000L
#define  Z3D_VIEWFLAG_NOGRID              0x02000000L
#define  Z3D_VIEWFLAG_NOGRIDTENTH         0x04000000L
#define  Z3D_VIEWFLAG_NOGRIDAXIS          0x08000000L
#define  Z3D_VIEWFLAG_NOIMAGE             0x10000000L
#define  Z3D_VIEWFLAG_SOLIDRENDER         0x20000000L
#define  Z3D_VIEWFLAG_ZBUFFERED           0x40000000L
#define  Z3D_VIEWFLAG_CUSTOMBACKGROUND    0x80000000L


//////////////////////////////////////////////////
//  UNDO blocks conditions
#define  UNDOCONDITION_OBJECTS            0x0001L
#define  UNDOCONDITION_EDGES              0x0002L
#define  UNDOCONDITION_FACES              0x0004L
#define  UNDOCONDITION_VERTICES           0x0008L
#define  UNDOCONDITION_SPLINES            0x0010L
#define  UNDOCONDITION_SPLINEVERTICES     0x0020L
#define  UNDOCONDITION_MARKED             0x0200L
#define  UNDOCONDITION_SELECTED           0x0400L
#define  UNDOCONDITION_EXTENDED           0x0800L
#define  UNDOCONDITION_NORMAUTO           0x1000L


//////////////////////////////////////////////////
//    Splines:

// custom edit parameters
#define  Z3D_SPLINE_CUSTOMDRAW            0x00000010L
#define  Z3D_SPLINE_CUSTOMEDIT            0x00000020L
#define  Z3D_SPLINE_CUSTOMDELETE          0x00000040L
///custom undo parameters
#define  Z3D_SPLINE_CUSTOMUNDO            0x00000100L
///custom access in internal procs parameters
#define  Z3D_SPLINE_UNACCESSABLE          0x00001000L
#define  Z3D_SPLINE_INTERNALSKIP          0x00002000L

#endif
